//
//  MCHistoryItem.h
//  MCApplication
//
//  Created by Ali Lalani on 7/16/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import <MCFoundation/MCSourceList.h>

@interface MCHistoryItem : NSObject {
	id object;
	id <MCSourceList> sourceList;
	NSMutableDictionary *displayState;
	NSImage *icon;
	NSCalendarDate *lastViewed;
	
	NSString *title; // derived from the object passed in, or set by the implementer
}
#pragma mark SetupAndConfiguration
- (id)initWithObject:(id)anObj sourceList:(id <MCSourceList>)aSourceList 
		displayState:(NSMutableDictionary *)aDisplayState;

#pragma mark Accessors
- (id)object;
- (void)setObject:(id)anObject;
- (id <MCSourceList>)sourceList;
- (void)setSourceList:(id <MCSourceList>)aSourceList;
- (NSMutableDictionary *)displayState;
- (void)setDisplayState:(NSMutableDictionary *)aDisplayState;
- (NSImage *)icon;
- (void)setIcon:(NSImage *)anIcon;

- (NSString *)title;
- (void)setTitle:(NSString *)aTitle;

- (NSCalendarDate *)lastViewed;
- (void)setLastViewed:(NSCalendarDate *)aLastViewed;
@end
